 Replication for: How Constitutional and Institutional Rules Affect Non-partisan Ministerial Appointments: Europe 1945–2024
 
 
 * Replicate Table 1
 
 preserve

. // Calculate statistics for EACH country-institution combination

. collapse (mean) mean_nonparti= nonpart_p (max) max_nonparti=nonpart_p (count) n_cabinets=nonpart_p, by(var01_re prel prparldis prcabdis pmparldis govparldis) 

. 
. * Convert to Yes/- format

. foreach var in prel prparldis prcabdis pmparldis {
  2.     gen `var'_str = cond(`var'==1, "Yes", "  -")
  3.     drop `var'
  4. }

. 
. * Format numbers

. format mean_nonparti max_nonparti %5.1f

. 
. * Sort by country and then by mean

. sort var01_re mean_nonparti

. 
. * Display - will show multiple rows per country if institutions changed

. list var01_re prel_str prparldis_str prcabdis_str pmparldis_str mean_nonparti max_nonparti n_cabinets, sep(0) noobs clean

restore

* Mean of non-partisan ministers by constitutional and institutional factors (Table 1)

foreach var in prel prparldis prcabdis pmparldis govparldis {
    display _newline "Mean of nonparti_var by `var':"
    tabstat nonparti_var, by(`var') stat(mean n sd) format(%9.3f)
}


** Replicate Table 2

preserve

* Create indicator for cabinets with at least one non-partisan minister
gen has_nonpartisan = (nonparti_var > 0)

* Collapse to country level
collapse (sum) n_with_nonpartisan=has_nonpartisan ///
         (count) total_cabinets=cabinet_re, ///
         by(var01_re)

* Calculate percentage
gen pct_with_nonpartisan = (n_with_nonpartisan/total_cabinets) * 100

* Format the percentage
format pct_with_nonpartisan %6.1f

* Sort by percentage (descending)
gsort -pct_with_nonpartisan var01_re

* Label variables for display
label var var01_re "Country"
label var n_with_nonpartisan "N cabinets with at least one non-partisan minister"
label var pct_with_nonpartisan "Percentage of cabinets with at least one non-partisan minister"
label var total_cabinets "Total number of cabinets"

* Display the table
list var01_re n_with_nonpartisan pct_with_nonpartisan total_cabinets, ///
     sep(0) noobs clean abbreviate(30)

* Add totals row
quietly sum n_with_nonpartisan
local total_with = r(sum)
quietly sum total_cabinets
local total_all = r(sum)
local total_pct = (`total_with'/`total_all') * 100

display _newline "Total: `total_with' cabinets with non-partisan ministers out of `total_all' total cabinets (`total_pct'%)"

restore

* Replicate Table 3

/*==============================================================================
Fractional Response Models - Replication Package
Requires: frm package for fractional response estimation
==============================================================================*/

// Document exact package versions
which frm
*Version 1.1.2 - 27 May 2014 // used for the analysis

// Install if needed (comment out after installation)
* ssc install frm


/*------------------------------------------------------------------------------
Fractional Response Models
Dependent variable: [nonparti_var] ranges from 0 to 1
Estimation method: Fractional logit (Papke & Wooldridge, 1996)
------------------------------------------------------------------------------*/

// Verify DV is properly bounded
summarize nonparti_var, detail
assert nonparti_var >= 0 & nonparti_var <= 1

// Test of the functional form for a binary partisan

frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re) // Logit specification
estimates store a1
estat ic
frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) linkbin(cauchit) inf(0) vcebin(cluster var01_re) // Cauchit specification
estimates store a2
estat ic
frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) linkbin(loglog) inf(0) vcebin(cluster var01_re) // Loglog specification
estimates store a3
estat ic
frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) linkbin(cloglog) inf(0) vcebin(cluster var01_re) // Cloglog specification
estimates store a4
estat ic
frm_reset a1, lr l(2)
frm_reset a2, lr l(2)
frm_reset a3, lr l(2)
frm_reset a4, lr l(2)

// Test of the fractional part of the model

frm nonpartie_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) vcefrac(cluster var01_re) // logit specification
estimates store a1
frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(cauchit) vcefrac(cluster var01_re) // cauchit specification
estimates store a2
frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog) vcefrac(cluster var01_re) // loglog specification
estimates store a3
frm nonparti_var prel pmparldis prparldis prcabdis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(cloglog) vcefrac(cluster var01_re) // cloglog specification
estimates store a4
frm_ptest, mod1(a1) mod2(a2)
 frm_ptest, mod1(a1) mod2(a3)
 frm_ptest, mod1(a1) mod2(a4)
 frm_ptest, mod1(a2) mod2(a3)
 frm_ptest, mod1(a2) mod2(a4)
 frm_ptest, mod1(a3) mod2(a4)

// replicate Table 3

frm nonparti_var prel pmparldis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re) // ** Model I, binary part

frm nonparti_var prel pmparldis prparldis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re) // ** Model II, binary part

frm nonparti_var prel pmparldis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re) // ** Model I, fractional part

frm nonparti_var prel pmparldis prparldis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re) // ** Model II, fractional part


// Marginal effects and Figures 1-2

// Marginal effects and Figure 1

margins, dydx(prel pmparldis prparldis) // ** after Model II, binary part

marginsplot, horizontal yscale(reverse) ///
	xlabel(-.4(.2).4) ///
	ytitle("Effects with respect to") ///
	xtitle("Likelihood of having at least one non-partisan minister") ///
	ylabel(1 "Popularly elected president" 
	       2 "PM's dissolution power" 
		   3 "President's dissolution power", angle(0)) ///
    recast(scatter) ///
	ciopts(lwidth(thick) lcolor(black)) ///
	plot1opts(msymbol(circle) mcolor(black) msize(medium))  ///
	graphregion(color(white))

// Marginal effects and Figure 2

margins, dydx(prel pmparldis prparldis) // ** after Model II, fractional part
 
marginsplot, horizontal yscale(reverse) ///
    xlabel(-.15(.05).15) ///
    ytitle("Effects with respect to") ///
    xtitle("Magnitude of non-partisan ministerial appointments") ///
    ylabel(1 "Popularly elected president" ///
            2 "PM's dissolution power" ///
            3 "President's dissolution power", angle(0)) ///
    recast(scatter) ///
    ciopts(lwidth(thick) lcolor(black)) ///
    plot1opts(msymbol(circle) mcolor(black) msize(medium)) ///
    graphregion(color(white))


// Replicate fractional logistic IPW adjusted regression (Table 4)

teffects ipwra (nonparti_var prel cohab bicam minor care effnumbe coalp demwave partyinst pr, flogit) (prparldis)

teffects ipwra (nonparti_var prel cohab bicam minor care effnumbe coalp demwave partyinst pr, flogit) (prparldis), atet

// *** Supplementary materials***

// ** Replicate Figure A1

twoway (scatter  nonparti_var decade), by(var01_re)

// ** Replicate Figure A2

margins, dydx(minor care cohab effnumbe coalp pr bicam demwave partyinst) // ** after Model II, binary part

marginsplot, horizontal yscale(reverse) ///
	xlabel(-.5(.5)1.5) ///
	ytitle("Effects with respect to") ///
	xtitle("Likelihood of having at least one non-partisan minister") ///
	ylabel(1 "Minority cabinet" 2 "Caretaker cabinet" 3 "Cohabitation" 4 "Party-system fractionalization" 5 "Cabinet fractionalization" ///
	6 "Proportional system" 7 "Bicameralism" 8 "Age of Democracy (=new democracy)" 9 "Party institutionalization", angle(0)) ///
	recast(scatter) ///
	ciopts(lwidth(thick) lcolor(black)) ///
	plot1opts(msymbol(circle) mcolor(black) msize(medium)) ///
	graphregion(color(white))

// ** Replicate Figure A3

margins, at(effnumbe =(2(2)14))
marginsplot

margins, at(coalp=(0(2)8))
marginsplot

// ** Replicate Figure A4 // ** after Model II, fractional part

margins, dydx(minor care cohab effnumbe coalp pr bicam demwave partyinst)

marginsplot, horizontal yscale(reverse) ///
	ytitle("Effects with respect to") ///
	xtitle("Magnitude of non-partisan ministerial appointments") ///
	ylabel(1 "Minority cabinet" 2 "Caretaker cabinet" 3 "Cohabitation" 4 "Party-system fractionalization" 5 "Cabinet fractionalization" ///
	6 "Proportional system" 7 "Bicameralism" 8 "Age of Democracy (=new democracy)" 9 "Party institutionalization", angle(0)) ///
	recast(scatter) ///
	ciopts(lwidth(thick) lcolor(black)) plot1opts(msymbol(circle) mcolor(black) msize(medium)) graphregion(color(white))

// ** Replicate Figure A5

margins, at(effnumbe =(2(2)14))
marginsplot

margins, at(coalp=(0(2)8))
marginsplot

// ** Replicate Figure A6

frm nonparti_var prel pmparldis prparldis minor care cohab effnumbe coalp pr bicam demwave partyinst decade, m(2Pbin) inf(0) vcebin(cluster var01_re) 

margins, at(decade=(1940 1950 1960 1970 1980 1990 2000 2010 2020))

marginsplot, ytitle("Likelihood of having at least one non-partisan minister") ///
	xtitle("Decade") ///
	plot1opts(color(black)) ///
	ci1opts(color(black))
	
// ** Replicate Figure A7

frm nonparti_var prel pmparldis prparldis minor care cohab effnumbe coalp pr bicam demwave partyinst decade, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re)

margins, at(decade=(1940 1950 1960 1970 1980 1990 2000 2010 2020))

marginsplot, ytitle("Likelihood of having at least one non-partisan minister") ///
	xtitle("Decade") ///
	plot1opts(color(black)) ///
	ci1opts(color(black))
	
// ** Replicate Table A1

// Table A1, Model I

frm nonparti_var prespow minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re) 
frm nonparti_var prespow minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re) 

// Table A1, Model II

drop if prespow==0

frm nonparti_var prespow minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re) 
frm nonparti_var prespow minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re) 

// **Replicate Table A2 (binary part) and Figure A8

frm nonparti_var pmparldis presparl prempres minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re)

margins, dydx( presparl prempres pmparldis)

marginsplot, horizontal yscale(reverse) ///
	ytitle("Effects with respect to") ///
	xtitle("Likelihood of having at least one non-partisan minister") ///
	ylabel(1 "PM's dissolution power" 2 "President-parliamentarism" 3 "Premier-presidentialism", angle(0)) ///
	recast(scatter) ///
	ciopts(lwidth(thick) lcolor(black)) plot1opts(msymbol(circle) mcolor(black) msize(medium)) graphregion(color(white))
	
// ** Replicate Table A2 (fractional part) and Figure A9

frm nonparti_var pmparldis presparl prempres minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re)

margins, dydx( presparl prempres pmparldis)

marginsplot, horizontal yscale(reverse)///
	ytitle("Effects with respect to") /// 
	xtitle("Magnitude of non-partisan ministerial appointments") ///
	ylabel(1 "PM's dissolution power" 2 "President-parliamentarism" 3 "Premier-presidentialism", angle(0)) ///
	recast(scatter) ///
	ciopts(lwidth(thick) lcolor(black)) plot1opts(msymbol(circle) mcolor(black) msize(medium)) graphregion(color(white))
	

// ** Replicate Table A3 (binary part) and Figure A10

frm nonparti_var prel prparldis prcabdis pmparldis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pbin) inf(0) vcebin(cluster var01_re)

margins, dydx(prel pmparldis prparldis prcabdis)

marginsplot, horizontal yscale(reverse) ///
	ytitle("Effects with respect to") ///
	xtitle("Likelihood of having at least one non-partisan minister") ///
	ylabel(1 "Popularly elected president" 2 "President can dissolve the parliament" 3 "President can dismiss cabinet" 4 "PM's dissolution power", angle(0)) ///
	recast(scatter) /// 
	ciopts(lwidth(thick) lcolor(black)) plot1opts(msymbol(circle) mcolor(black) msize(medium)) graphregion(color(white))
	
// ** Replicate Table A3 (fractional part) and Figure A11

frm nonparti_var prel prparldis prcabdis pmparldis minor care cohab effnumbe coalp pr bicam demwave partyinst, m(2Pfrac) inf(0) linkfrac(loglog)  vcefrac(cluster var01_re)

margins, dydx(prel pmparldis prparldis prcabdis)

marginsplot, horizontal yscale(reverse) ///
	ytitle("Effects with respect to") ///
	xtitle("Magnitude of non-partisan ministerial appointments") ///
	ylabel(1 "Popularly elected president" 2 "President can dissolve the parliament" 3 "President can dismiss cabinet" 4 "PM's dissolution power", angle(0)) ///
	recast(scatter) ///
	ciopts(lwidth(thick) lcolor(black)) plot1opts(msymbol(circle) mcolor(black) msize(medium)) graphregion(color(white))

	
	